#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>
#include <cassert>
#include <climits>
#include <numeric>

using namespace std;

const long long maxi = LLONG_MAX;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), h(n), sortx(n), sorth(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> h[i];
    vector<int> p(n);
    iota(p.begin(), p.end(), 0);
    vector<pair<long long, long long>> v(n);
    for (int i = 0; i < n; i++) {
        v[i] = { x[i], h[i] };
    }
    sort(v.begin(), v.end());
    for (int i = 0; i < n; i++) {
        sortx[i] = v[i].first;
        sorth[i] = v[i].second;
    }
    vector<long long> res(n, maxi);
    stack<int> s;
    for (int i = 0; i < n; ++i) {
        while (!s.empty() && sorth[s.top()] < sorth[i]) s.pop();
        if (!s.empty()) {
            int j = s.top();
            long long d = (sortx[i] - sortx[j]) - (sorth[j] - sorth[i]);
            res[p[i]] = min(res[p[i]], d);
        }
        s.push(i);
    }
    while (!s.empty()) s.pop();
    for (int i = n - 1; i >= 0; --i) {
        while (!s.empty() && sorth[s.top()] < sorth[i]) s.pop();
        if (!s.empty()) {
            int j = s.top();
            long long d = (sortx[j] - sortx[i]) - (sorth[j] - sorth[i]);
            res[p[i]] = min(res[p[i]], d);
        }
        s.push(i);
    }
    for (int i = 0; i < n; ++i) {
        if (res[i] == maxi) cout << -1 << '\n';
        else cout << res[i] << '\n';
    }
    return 0;
}